/*****************************************************************************
*  LPC11U6x Match Toggle program
*
*  1. Use SCT timer to generate a 100 msec clock output @ SCT1_OUT0
*  2. SCT1_OUT0 is linked to P2_16 (toggles every 100 msec)
*****************************************************************************/
#include "board.h"

extern void SCT1_Init(void);


void SCT1_Init(void)
{

	Chip_SCT_Init(LPC_SCT1);							   						                  //enable clock for SCT0/1

	Chip_SCT_Config(LPC_SCT1,  SCT_CONFIG_AUTOLIMIT_L);										//two 16-bit timers, clocked internally, auto limit


	Chip_SCT_SetControl(LPC_SCT1, SCT_CTRL_PRE_L(119));								// set prescaler, PRE_L[12:5] = 120-1 (SCT clock = 12MHz/120 = 100 KHz)

	Chip_SCT_SetMatchCount(LPC_SCT1, SCT_MATCH_0, (100000/10)-1);						// match 0 @ 10 Hz = 100 msec
	Chip_SCT_SetMatchReload(LPC_SCT1, SCT_MATCH_0, (100000/10)-1);


	Chip_SCT_EventState(LPC_SCT1, SCT_EVENT_0, ENABLE_STATE0);					// event 0 only happens in state 0
	Chip_SCT_EventControl(LPC_SCT1, SCT_EVENT_0, (CHIP_SCT_EVENTCTRL_T) ( SCT_EVECTRL_MATCH0	|			// related to match 0
                                                                        SCT_COMBMODE_MATCH	|			// COMBMODE[13:12] = match condition only
                                                                        SCT_STATELD_1		    |			// STATELD[14] = STATEV is loaded into state
                                                                        SCT_STATEEV_0		    ));		// STATEV[15] = 0


	Chip_SCT_SetOutput(LPC_SCT1, SCT_OUTPUT_0 , SCT_EVT_0);						// event 0 will set SCTx_OUT0
	Chip_SCT_ClearOutput(LPC_SCT1, SCT_OUTPUT_0, SCT_EVT_0);					// event 1 will clear SCTx_OUT0

	Chip_SCT_SetConflictResolution(LPC_SCT1, 0, SCT_RES_TOGGLE_OUTPUT);			// output 0 toggles on conflict

	Chip_SCT_ClearControl(LPC_SCT1, SCT_CTRL_HALT_L);							// unhalt it by clearing bit 2 of the CTRL register
}





int main (void) 
{
	SystemCoreClockUpdate();
	Chip_Clock_SetSysClockDiv(4);											// SystemCoreClock/4 = 12Mhz
	Board_Init();


	Chip_Clock_EnablePeriphClock(SYSCTL_CLOCK_IOCON);	// enable clock for IOCON


	Chip_IOCON_PinMuxSet(LPC_IOCON, 2,16 ,0x00000081);	// P2_16 is SCT1_OUT0

    SCT1_Init();                                   		// Initialize SCT

    while (1) 
    {
    	__WFI();
    }
}

